%------------------------------------------------------------------------------
% File     : DAT210^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Splay tree analysis 65
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Nip14] Nipkow (2014), Amortized Complexity Verified
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : splay_tree_analysis__65.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.5.0, 0.33 v7.2.0, 0.25 v7.1.0
% Syntax   : Number of formulae    :  373 ( 120 unt;  66 typ;   0 def)
%            Number of atoms       :  760 ( 314 equ;   0 cnn)
%            Maximal formula atoms :   11 (   2 avg)
%            Number of connectives : 4377 ( 107   ~;   4   |;  37   &;3870   @)
%                                         (   0 <=>; 359  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   7 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  159 ( 159   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   67 (  64 usr;   2 con; 0-5 aty)
%            Number of variables   : 1098 (  13   ^; 993   !;  25   ?;1098   :)
%                                         (  67  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:48:43.839
%------------------------------------------------------------------------------
%----Could-be-implicit typings (6)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Tree_Otree,type,
    tree: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (60)
thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ozero__less__one,type,
    zero_less_one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ostrict__ordered__comm__monoid__add,type,
    strict797366125id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ostrict__ordered__ab__semigroup__add,type,
    strict2144017051up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__monoid__add__imp__le,type,
    ordere516151231imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_Num_Oneg__numeral__class_Odbl__inc,type,
    neg_numeral_dbl_inc: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Ointernal__case__prod,type,
    produc2004651681e_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Pure_Otype,type,
    type: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set__Interval_Ofold__atLeastAtMost__nat,type,
    set_fo292404081st_nat: 
      !>[A: $tType] : ( ( nat > A > A ) > nat > nat > A > A ) ).

thf(sy_c_Splay__Tree_Ois__root,type,
    splay_is_root: 
      !>[A: $tType] : ( A > ( tree @ A ) > $o ) ).

thf(sy_c_Splay__Tree_Osplay,type,
    splay_splay: 
      !>[A: $tType] : ( A > ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Splay__Tree_Osplay__max,type,
    splay_splay_max: 
      !>[A: $tType] : ( ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Splay__Tree__Analysis__Base_Ot__splay,type,
    splay_914434265_splay: 
      !>[A: $tType] : ( A > ( tree @ A ) > nat ) ).

thf(sy_c_Splay__Tree__Analysis__Base_Ot__splay__max,type,
    splay_878424299ay_max: 
      !>[A: $tType] : ( ( tree @ A ) > nat ) ).

thf(sy_c_Splay__Tree__Analysis__Mirabelle__pcaxyvimtd_OA,type,
    splay_266122055elle_A: 
      !>[A: $tType] : ( A > ( tree @ A ) > real ) ).

thf(sy_c_Tree_Olinorder__class_Obst,type,
    linorder_bst: 
      !>[A: $tType] : ( ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Omirror,type,
    mirror: 
      !>[A: $tType] : ( ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Tree_Opath__len,type,
    path_len: 
      !>[A: $tType] : ( ( tree @ A ) > nat ) ).

thf(sy_c_Tree_Osize1,type,
    size1: 
      !>[A: $tType] : ( ( tree @ A ) > nat ) ).

thf(sy_c_Tree_Osubtrees,type,
    subtrees: 
      !>[A: $tType] : ( ( tree @ A ) > ( set @ ( tree @ A ) ) ) ).

thf(sy_c_Tree_Otree_OLeaf,type,
    leaf: 
      !>[A: $tType] : ( tree @ A ) ).

thf(sy_c_Tree_Otree_ONode,type,
    node: 
      !>[A: $tType] : ( ( tree @ A ) > A > ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Tree_Otree_Orec__tree,type,
    rec_tree: 
      !>[C: $tType,A: $tType] : ( C > ( ( tree @ A ) > A > ( tree @ A ) > C > C > C ) > ( tree @ A ) > C ) ).

thf(sy_c_Tree_Otree_Oset__tree,type,
    set_tree: 
      !>[A: $tType] : ( ( tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ B @ B ) ) > ( set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) ) ) ).

thf(sy_c_Wellfounded_Omeasure,type,
    measure: 
      !>[A: $tType] : ( ( A > nat ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Wellfounded_Omlex__prod,type,
    mlex_prod: 
      !>[A: $tType] : ( ( A > nat ) > ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

%----Relevant facts (253)
thf(fact_0_A__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,L: tree @ A,R: tree @ A] :
          ( ( splay_266122055elle_A @ A @ A2 @ ( node @ A @ L @ A2 @ R ) )
          = ( one_one @ real ) ) ) ).

% A_simps(1)
thf(fact_1_tree_Oinject,axiom,
    ! [A: $tType,X21: tree @ A,X22: A,X23: tree @ A,Y21: tree @ A,Y22: A,Y23: tree @ A] :
      ( ( ( node @ A @ X21 @ X22 @ X23 )
        = ( node @ A @ Y21 @ Y22 @ Y23 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 )
        & ( X23 = Y23 ) ) ) ).

% tree.inject
thf(fact_2_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A @ ( type @ A ) )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_3_tree_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: tree @ A,X22: A,X23: tree @ A] :
      ( ( leaf @ A )
     != ( node @ A @ X21 @ X22 @ X23 ) ) ).

% tree.distinct(1)
thf(fact_4_tree_Oinduct,axiom,
    ! [A: $tType,P: ( tree @ A ) > $o,Tree: tree @ A] :
      ( ( P @ ( leaf @ A ) )
     => ( ! [X1: tree @ A,X2: A,X3: tree @ A] :
            ( ( P @ X1 )
           => ( ( P @ X3 )
             => ( P @ ( node @ A @ X1 @ X2 @ X3 ) ) ) )
       => ( P @ Tree ) ) ) ).

% tree.induct
thf(fact_5_neq__Leaf__iff,axiom,
    ! [A: $tType,T2: tree @ A] :
      ( ( T2
       != ( leaf @ A ) )
      = ( ? [L2: tree @ A,A3: A,R2: tree @ A] :
            ( T2
            = ( node @ A @ L2 @ A3 @ R2 ) ) ) ) ).

% neq_Leaf_iff
thf(fact_6_tree_Oexhaust,axiom,
    ! [A: $tType,Y: tree @ A] :
      ( ( Y
       != ( leaf @ A ) )
     => ~ ! [X212: tree @ A,X222: A,X232: tree @ A] :
            ( Y
           != ( node @ A @ X212 @ X222 @ X232 ) ) ) ).

% tree.exhaust
thf(fact_7_mirror_Oinduct,axiom,
    ! [A: $tType,P: ( tree @ A ) > $o,A0: tree @ A] :
      ( ( P @ ( leaf @ A ) )
     => ( ! [L3: tree @ A,X4: A,R3: tree @ A] :
            ( ( P @ R3 )
           => ( ( P @ L3 )
             => ( P @ ( node @ A @ L3 @ X4 @ R3 ) ) ) )
       => ( P @ A0 ) ) ) ).

% mirror.induct
thf(fact_8_bst__eq_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: tree @ A] :
          ( ( X
           != ( leaf @ A ) )
         => ~ ! [L3: tree @ A,A4: A,R3: tree @ A] :
                ( X
               != ( node @ A @ L3 @ A4 @ R3 ) ) ) ) ).

% bst_eq.cases
thf(fact_9_bst__eq_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [P: ( tree @ A ) > $o,A0: tree @ A] :
          ( ( P @ ( leaf @ A ) )
         => ( ! [L3: tree @ A,A4: A,R3: tree @ A] :
                ( ( P @ L3 )
               => ( ( P @ R3 )
                 => ( P @ ( node @ A @ L3 @ A4 @ R3 ) ) ) )
           => ( P @ A0 ) ) ) ) ).

% bst_eq.induct
thf(fact_10__092_060Phi_062_Ocases,axiom,
    ! [A: $tType,X: tree @ A] :
      ( ( X
       != ( leaf @ A ) )
     => ~ ! [L3: tree @ A,A4: A,R3: tree @ A] :
            ( X
           != ( node @ A @ L3 @ A4 @ R3 ) ) ) ).

% \<Phi>.cases
thf(fact_11__092_060Phi_062_Oinduct,axiom,
    ! [A: $tType,P: ( tree @ A ) > $o,A0: tree @ A] :
      ( ( P @ ( leaf @ A ) )
     => ( ! [L3: tree @ A,A4: A,R3: tree @ A] :
            ( ( P @ L3 )
           => ( ( P @ R3 )
             => ( P @ ( node @ A @ L3 @ A4 @ R3 ) ) ) )
       => ( P @ A0 ) ) ) ).

% \<Phi>.induct
thf(fact_12_t__splay__max_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [P: ( tree @ A ) > $o,A0: tree @ A] :
          ( ( P @ ( leaf @ A ) )
         => ( ! [L3: tree @ A,B2: A] : ( P @ ( node @ A @ L3 @ B2 @ ( leaf @ A ) ) )
           => ( ! [L3: tree @ A,B2: A,Rl: tree @ A,C2: A,Rr: tree @ A] :
                  ( ( ( Rr
                     != ( leaf @ A ) )
                   => ( P @ Rr ) )
                 => ( P @ ( node @ A @ L3 @ B2 @ ( node @ A @ Rl @ C2 @ Rr ) ) ) )
             => ( P @ A0 ) ) ) ) ) ).

% t_splay_max.induct
thf(fact_13_t__splay__max_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: tree @ A] :
          ( ( X
           != ( leaf @ A ) )
         => ( ! [L3: tree @ A,B2: A] :
                ( X
               != ( node @ A @ L3 @ B2 @ ( leaf @ A ) ) )
           => ~ ! [L3: tree @ A,B2: A,Rl: tree @ A,C2: A,Rr: tree @ A] :
                  ( X
                 != ( node @ A @ L3 @ B2 @ ( node @ A @ Rl @ C2 @ Rr ) ) ) ) ) ) ).

% t_splay_max.cases
thf(fact_14_bst_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ( linorder_bst @ A @ ( leaf @ A ) ) ) ).

% bst.simps(1)
thf(fact_15_t__splay__max_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [L: tree @ A,B3: A] :
          ( ( splay_878424299ay_max @ A @ ( node @ A @ L @ B3 @ ( leaf @ A ) ) )
          = ( one_one @ nat ) ) ) ).

% t_splay_max.simps(2)
thf(fact_16_mirror_Oelims,axiom,
    ! [A: $tType,X: tree @ A,Y: tree @ A] :
      ( ( ( mirror @ A @ X )
        = Y )
     => ( ( ( X
            = ( leaf @ A ) )
         => ( Y
           != ( leaf @ A ) ) )
       => ~ ! [L3: tree @ A,X4: A,R3: tree @ A] :
              ( ( X
                = ( node @ A @ L3 @ X4 @ R3 ) )
             => ( Y
               != ( node @ A @ ( mirror @ A @ R3 ) @ X4 @ ( mirror @ A @ L3 ) ) ) ) ) ) ).

% mirror.elims
thf(fact_17_t__splay__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,R: tree @ A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ ( leaf @ A ) @ B3 @ R ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(2)
thf(fact_18_t__splay__simps_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,L: tree @ A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ B3 @ ( leaf @ A ) ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(6)
thf(fact_19_t__splay__max_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ( ( splay_878424299ay_max @ A @ ( leaf @ A ) )
        = ( one_one @ nat ) ) ) ).

% t_splay_max.simps(1)
thf(fact_20_mirror__Leaf,axiom,
    ! [A: $tType,T2: tree @ A] :
      ( ( ( mirror @ A @ T2 )
        = ( leaf @ A ) )
      = ( T2
        = ( leaf @ A ) ) ) ).

% mirror_Leaf
thf(fact_21_tree_Osimps_I6_J,axiom,
    ! [A: $tType,C: $tType,F1: C,F2: ( tree @ A ) > A > ( tree @ A ) > C > C > C] :
      ( ( rec_tree @ C @ A @ F1 @ F2 @ ( leaf @ A ) )
      = F1 ) ).

% tree.simps(6)
thf(fact_22_tree_Osimps_I7_J,axiom,
    ! [C: $tType,A: $tType,F1: C,F2: ( tree @ A ) > A > ( tree @ A ) > C > C > C,X21: tree @ A,X22: A,X23: tree @ A] :
      ( ( rec_tree @ C @ A @ F1 @ F2 @ ( node @ A @ X21 @ X22 @ X23 ) )
      = ( F2 @ X21 @ X22 @ X23 @ ( rec_tree @ C @ A @ F1 @ F2 @ X21 ) @ ( rec_tree @ C @ A @ F1 @ F2 @ X23 ) ) ) ).

% tree.simps(7)
thf(fact_23_t__splay_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: product_prod @ A @ ( tree @ A )] :
          ( ! [A4: A] :
              ( X
             != ( product_Pair @ A @ ( tree @ A ) @ A4 @ ( leaf @ A ) ) )
         => ~ ! [A4: A,L3: tree @ A,B2: A,R3: tree @ A] :
                ( X
               != ( product_Pair @ A @ ( tree @ A ) @ A4 @ ( node @ A @ L3 @ B2 @ R3 ) ) ) ) ) ).

% t_splay.cases
thf(fact_24_size1__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( size1 @ A @ ( leaf @ A ) )
      = ( one_one @ nat ) ) ).

% size1_simps(1)
thf(fact_25_mirror__mirror,axiom,
    ! [A: $tType,T2: tree @ A] :
      ( ( mirror @ A @ ( mirror @ A @ T2 ) )
      = T2 ) ).

% mirror_mirror
thf(fact_26_size1__mirror,axiom,
    ! [A: $tType,T2: tree @ A] :
      ( ( size1 @ A @ ( mirror @ A @ T2 ) )
      = ( size1 @ A @ T2 ) ) ).

% size1_mirror
thf(fact_27_t__splay__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,L: tree @ A,R: tree @ A] :
          ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ A2 @ R ) )
          = ( one_one @ nat ) ) ) ).

% t_splay_simps(1)
thf(fact_28_t__splay__simps_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,L: tree @ A,Rl2: tree @ A,Rr2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ A2 @ Rr2 ) ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(7)
thf(fact_29_t__splay__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,Ll: tree @ A,Lr: tree @ A,R: tree @ A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ ( node @ A @ Ll @ A2 @ Lr ) @ B3 @ R ) )
            = ( one_one @ nat ) ) ) ) ).

% t_splay_simps(3)
thf(fact_30_t__splay_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( splay_914434265_splay @ A @ A2 @ ( leaf @ A ) )
          = ( one_one @ nat ) ) ) ).

% t_splay.simps(1)
thf(fact_31_mirror_Osimps_I2_J,axiom,
    ! [A: $tType,L: tree @ A,X: A,R: tree @ A] :
      ( ( mirror @ A @ ( node @ A @ L @ X @ R ) )
      = ( node @ A @ ( mirror @ A @ R ) @ X @ ( mirror @ A @ L ) ) ) ).

% mirror.simps(2)
thf(fact_32_mirror_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( mirror @ A @ ( leaf @ A ) )
      = ( leaf @ A ) ) ).

% mirror.simps(1)
thf(fact_33_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X12: A,X24: B,Y1: A,Y2: B] :
      ( ( ( product_Pair @ A @ B @ X12 @ X24 )
        = ( product_Pair @ A @ B @ Y1 @ Y2 ) )
      = ( ( X12 = Y1 )
        & ( X24 = Y2 ) ) ) ).

% prod.inject
thf(fact_34_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B,A5: A,B4: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B3 )
        = ( product_Pair @ A @ B @ A5 @ B4 ) )
      = ( ( A2 = A5 )
        & ( B3 = B4 ) ) ) ).

% old.prod.inject
thf(fact_35_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_36_t__splay__simps_I9_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,C3: A,Rr2: tree @ A,L: tree @ A,Rl2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( ord_less @ A @ C3 @ A2 )
           => ( ( ( Rr2
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ C3 @ Rr2 ) ) )
                  = ( one_one @ nat ) ) )
              & ( ( Rr2
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ C3 @ Rr2 ) ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A2 @ Rr2 ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(9)
thf(fact_37_t__splay__simps_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,C3: A,Rl2: tree @ A,L: tree @ A,Rr2: tree @ A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( ord_less @ A @ A2 @ C3 )
           => ( ( ( Rl2
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ C3 @ Rr2 ) ) )
                  = ( one_one @ nat ) ) )
              & ( ( Rl2
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ C3 @ Rr2 ) ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A2 @ Rl2 ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(8)
thf(fact_38_t__splay__simps_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A,Lr: tree @ A,Ll: tree @ A,R: tree @ A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less @ A @ C3 @ A2 )
           => ( ( ( Lr
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ ( node @ A @ Ll @ C3 @ Lr ) @ B3 @ R ) )
                  = ( one_one @ nat ) ) )
              & ( ( Lr
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ ( node @ A @ Ll @ C3 @ Lr ) @ B3 @ R ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A2 @ Lr ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(5)
thf(fact_39_t__splay__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A,Ll: tree @ A,Lr: tree @ A,R: tree @ A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less @ A @ A2 @ C3 )
           => ( ( ( Ll
                  = ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ ( node @ A @ Ll @ C3 @ Lr ) @ B3 @ R ) )
                  = ( one_one @ nat ) ) )
              & ( ( Ll
                 != ( leaf @ A ) )
               => ( ( splay_914434265_splay @ A @ A2 @ ( node @ A @ ( node @ A @ Ll @ C3 @ Lr ) @ B3 @ R ) )
                  = ( plus_plus @ nat @ ( splay_914434265_splay @ A @ A2 @ Ll ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ).

% t_splay_simps(4)
thf(fact_40_t__splay__max_Osimps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [Rr2: tree @ A,L: tree @ A,B3: A,Rl2: tree @ A,C3: A] :
          ( ( ( Rr2
              = ( leaf @ A ) )
           => ( ( splay_878424299ay_max @ A @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ C3 @ Rr2 ) ) )
              = ( one_one @ nat ) ) )
          & ( ( Rr2
             != ( leaf @ A ) )
           => ( ( splay_878424299ay_max @ A @ ( node @ A @ L @ B3 @ ( node @ A @ Rl2 @ C3 @ Rr2 ) ) )
              = ( plus_plus @ nat @ ( splay_878424299ay_max @ A @ Rr2 ) @ ( one_one @ nat ) ) ) ) ) ) ).

% t_splay_max.simps(3)
thf(fact_41_t__splay__max_Oelims,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: tree @ A,Y: nat] :
          ( ( ( splay_878424299ay_max @ A @ X )
            = Y )
         => ( ( ( X
                = ( leaf @ A ) )
             => ( Y
               != ( one_one @ nat ) ) )
           => ( ( ? [L3: tree @ A,B2: A] :
                    ( X
                    = ( node @ A @ L3 @ B2 @ ( leaf @ A ) ) )
               => ( Y
                 != ( one_one @ nat ) ) )
             => ~ ! [L3: tree @ A,B2: A,Rl: tree @ A,C2: A,Rr: tree @ A] :
                    ( ( X
                      = ( node @ A @ L3 @ B2 @ ( node @ A @ Rl @ C2 @ Rr ) ) )
                   => ~ ( ( ( Rr
                            = ( leaf @ A ) )
                         => ( Y
                            = ( one_one @ nat ) ) )
                        & ( ( Rr
                           != ( leaf @ A ) )
                         => ( Y
                            = ( plus_plus @ nat @ ( splay_878424299ay_max @ A @ Rr ) @ ( one_one @ nat ) ) ) ) ) ) ) ) ) ) ).

% t_splay_max.elims
thf(fact_42_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,C3: A] :
          ( ( ( plus_plus @ A @ B3 @ A2 )
            = ( plus_plus @ A @ C3 @ A2 ) )
          = ( B3 = C3 ) ) ) ).

% add_right_cancel
thf(fact_43_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( ( plus_plus @ A @ A2 @ B3 )
            = ( plus_plus @ A @ A2 @ C3 ) )
          = ( B3 = C3 ) ) ) ).

% add_left_cancel
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A6: set @ A] :
      ( ( collect @ A
        @ ^ [X5: A] : ( member @ A @ X5 @ A6 ) )
      = A6 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [A2: A,C3: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C3 ) @ ( plus_plus @ A @ B3 @ C3 ) )
          = ( ord_less @ A @ A2 @ B3 ) ) ) ).

% add_less_cancel_right
thf(fact_49_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [C3: A,A2: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C3 @ A2 ) @ ( plus_plus @ A @ C3 @ B3 ) )
          = ( ord_less @ A @ A2 @ B3 ) ) ) ).

% add_less_cancel_left
thf(fact_50_size1__simps_I2_J,axiom,
    ! [B: $tType,L: tree @ B,X: B,R: tree @ B] :
      ( ( size1 @ B @ ( node @ B @ L @ X @ R ) )
      = ( plus_plus @ nat @ ( size1 @ B @ L ) @ ( size1 @ B @ R ) ) ) ).

% size1_simps(2)
thf(fact_51_is__num__normalize_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B3 ) @ C3 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B3 @ C3 ) ) ) ) ).

% is_num_normalize(1)
thf(fact_52_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,C3: A] :
          ( ( ( plus_plus @ A @ B3 @ A2 )
            = ( plus_plus @ A @ C3 @ A2 ) )
         => ( B3 = C3 ) ) ) ).

% add_right_imp_eq
thf(fact_53_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( ( plus_plus @ A @ A2 @ B3 )
            = ( plus_plus @ A @ A2 @ C3 ) )
         => ( B3 = C3 ) ) ) ).

% add_left_imp_eq
thf(fact_54_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,C3: A] :
          ( ( plus_plus @ A @ B3 @ ( plus_plus @ A @ A2 @ C3 ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B3 @ C3 ) ) ) ) ).

% add.left_commute
thf(fact_55_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,B5: A] : ( plus_plus @ A @ B5 @ A3 ) ) ) ) ).

% add.commute
thf(fact_56_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,C3: A] :
          ( ( ( plus_plus @ A @ B3 @ A2 )
            = ( plus_plus @ A @ C3 @ A2 ) )
          = ( B3 = C3 ) ) ) ).

% add.right_cancel
thf(fact_57_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( ( plus_plus @ A @ A2 @ B3 )
            = ( plus_plus @ A @ A2 @ C3 ) )
          = ( B3 = C3 ) ) ) ).

% add.left_cancel
thf(fact_58_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B3 ) @ C3 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B3 @ C3 ) ) ) ) ).

% add.assoc
thf(fact_59_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( K = L ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_60_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B3 ) @ C3 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B3 @ C3 ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_61_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [A2: A,C3: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C3 ) @ ( plus_plus @ A @ B3 @ C3 ) )
         => ( ord_less @ A @ A2 @ B3 ) ) ) ).

% add_less_imp_less_right
thf(fact_62_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [C3: A,A2: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C3 @ A2 ) @ ( plus_plus @ A @ C3 @ B3 ) )
         => ( ord_less @ A @ A2 @ B3 ) ) ) ).

% add_less_imp_less_left
thf(fact_63_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ord_less @ A @ ( plus_plus @ A @ A2 @ C3 ) @ ( plus_plus @ A @ B3 @ C3 ) ) ) ) ).

% add_strict_right_mono
thf(fact_64_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ord_less @ A @ ( plus_plus @ A @ C3 @ A2 ) @ ( plus_plus @ A @ C3 @ B3 ) ) ) ) ).

% add_strict_left_mono
thf(fact_65_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ( strict2144017051up_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A,D: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less @ A @ C3 @ D )
           => ( ord_less @ A @ ( plus_plus @ A @ A2 @ C3 ) @ ( plus_plus @ A @ B3 @ D ) ) ) ) ) ).

% add_strict_mono
thf(fact_66_add__mono__thms__linordered__field_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( K = L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_67_add__mono__thms__linordered__field_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( ord_less @ A @ K @ L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_68_add__mono__thms__linordered__field_I5_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( ord_less @ A @ K @ L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_69_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A4: A,B2: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B2 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_70_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod @ A @ B] :
      ~ ! [A4: A,B2: B] :
          ( Y
         != ( product_Pair @ A @ B @ A4 @ B2 ) ) ).

% old.prod.exhaust
thf(fact_71_prod__induct7,axiom,
    ! [G2: $tType,F3: $tType,E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) )] :
      ( ! [A4: A,B2: B,C2: C,D3: D2,E2: E,F4: F3,G3: G2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) @ B2 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) @ C2 @ ( product_Pair @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) @ D3 @ ( product_Pair @ E @ ( product_prod @ F3 @ G2 ) @ E2 @ ( product_Pair @ F3 @ G2 @ F4 @ G3 ) ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct7
thf(fact_72_prod__induct6,axiom,
    ! [F3: $tType,E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) )] :
      ( ! [A4: A,B2: B,C2: C,D3: D2,E2: E,F4: F3] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) @ B2 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) @ C2 @ ( product_Pair @ D2 @ ( product_prod @ E @ F3 ) @ D3 @ ( product_Pair @ E @ F3 @ E2 @ F4 ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct6
thf(fact_73_prod__induct5,axiom,
    ! [E: $tType,D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) )] :
      ( ! [A4: A,B2: B,C2: C,D3: D2,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) @ B2 @ ( product_Pair @ C @ ( product_prod @ D2 @ E ) @ C2 @ ( product_Pair @ D2 @ E @ D3 @ E2 ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct5
thf(fact_74_prod__induct4,axiom,
    ! [D2: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) )] :
      ( ! [A4: A,B2: B,C2: C,D3: D2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D2 ) @ B2 @ ( product_Pair @ C @ D2 @ C2 @ D3 ) ) ) )
     => ( P @ X ) ) ).

% prod_induct4
thf(fact_75_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ C )] :
      ( ! [A4: A,B2: B,C2: C] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B2 @ C2 ) ) )
     => ( P @ X ) ) ).

% prod_induct3
thf(fact_76_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,F3: $tType,G2: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) )] :
      ~ ! [A4: A,B2: B,C2: C,D3: D2,E2: E,F4: F3,G3: G2] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) ) @ B2 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) ) @ C2 @ ( product_Pair @ D2 @ ( product_prod @ E @ ( product_prod @ F3 @ G2 ) ) @ D3 @ ( product_Pair @ E @ ( product_prod @ F3 @ G2 ) @ E2 @ ( product_Pair @ F3 @ G2 @ F4 @ G3 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_77_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,F3: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) )] :
      ~ ! [A4: A,B2: B,C2: C,D3: D2,E2: E,F4: F3] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) ) @ B2 @ ( product_Pair @ C @ ( product_prod @ D2 @ ( product_prod @ E @ F3 ) ) @ C2 @ ( product_Pair @ D2 @ ( product_prod @ E @ F3 ) @ D3 @ ( product_Pair @ E @ F3 @ E2 @ F4 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_78_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,E: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) )] :
      ~ ! [A4: A,B2: B,C2: C,D3: D2,E2: E] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D2 @ E ) ) @ B2 @ ( product_Pair @ C @ ( product_prod @ D2 @ E ) @ C2 @ ( product_Pair @ D2 @ E @ D3 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_79_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D2: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) )] :
      ~ ! [A4: A,B2: B,C2: C,D3: D2] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D2 ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D2 ) @ B2 @ ( product_Pair @ C @ D2 @ C2 @ D3 ) ) ) ) ).

% prod_cases4
thf(fact_80_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod @ A @ ( product_prod @ B @ C )] :
      ~ ! [A4: A,B2: B,C2: C] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B2 @ C2 ) ) ) ).

% prod_cases3
thf(fact_81_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B,A5: A,B4: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B3 )
        = ( product_Pair @ A @ B @ A5 @ B4 ) )
     => ~ ( ( A2 = A5 )
         => ( B3 != B4 ) ) ) ).

% Pair_inject
thf(fact_82_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P2: product_prod @ A @ B] :
      ( ! [A4: A,B2: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B2 ) )
     => ( P @ P2 ) ) ).

% prod_cases
thf(fact_83_surj__pair,axiom,
    ! [A: $tType,B: $tType,P2: product_prod @ A @ B] :
    ? [X4: A,Y3: B] :
      ( P2
      = ( product_Pair @ A @ B @ X4 @ Y3 ) ) ).

% surj_pair
thf(fact_84_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B3: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B3 ) )
      = ( F1 @ A2 @ B3 ) ) ).

% old.prod.rec
thf(fact_85_less__add__one,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [A2: A] : ( ord_less @ A @ A2 @ ( plus_plus @ A @ A2 @ ( one_one @ A ) ) ) ) ).

% less_add_one
thf(fact_86_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_87_fold__atLeastAtMost__nat_Oinduct,axiom,
    ! [A: $tType,P: ( nat > A > A ) > nat > nat > A > $o,A0: nat > A > A,A1: nat,A22: nat,A32: A] :
      ( ! [F4: nat > A > A,A4: nat,B2: nat,Acc: A] :
          ( ( ~ ( ord_less @ nat @ B2 @ A4 )
           => ( P @ F4 @ ( plus_plus @ nat @ A4 @ ( one_one @ nat ) ) @ B2 @ ( F4 @ A4 @ Acc ) ) )
         => ( P @ F4 @ A4 @ B2 @ Acc ) )
     => ( P @ A0 @ A1 @ A22 @ A32 ) ) ).

% fold_atLeastAtMost_nat.induct
thf(fact_88_internal__case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,C3: B > C > A,A2: B,B3: C] :
      ( ( produc2004651681e_prod @ B @ C @ A @ C3 @ ( product_Pair @ B @ C @ A2 @ B3 ) )
      = ( C3 @ A2 @ B3 ) ) ).

% internal_case_prod_conv
thf(fact_89_dbl__inc__def,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type @ A ) )
     => ( ( neg_numeral_dbl_inc @ A )
        = ( ^ [X5: A] : ( plus_plus @ A @ ( plus_plus @ A @ X5 @ X5 ) @ ( one_one @ A ) ) ) ) ) ).

% dbl_inc_def
thf(fact_90_insert_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: product_prod @ A @ ( tree @ A )] :
          ~ ! [X4: A,T3: tree @ A] :
              ( X
             != ( product_Pair @ A @ ( tree @ A ) @ X4 @ T3 ) ) ) ).

% insert.cases
thf(fact_91_size1__def,axiom,
    ! [A: $tType] :
      ( ( size1 @ A )
      = ( ^ [T4: tree @ A] : ( plus_plus @ nat @ ( size_size @ ( tree @ A ) @ T4 ) @ ( one_one @ nat ) ) ) ) ).

% size1_def
thf(fact_92_size__mirror,axiom,
    ! [A: $tType,T2: tree @ A] :
      ( ( size_size @ ( tree @ A ) @ ( mirror @ A @ T2 ) )
      = ( size_size @ ( tree @ A ) @ T2 ) ) ).

% size_mirror
thf(fact_93_infinite__descent__measure,axiom,
    ! [A: $tType,P: A > $o,V: A > nat,X: A] :
      ( ! [X4: A] :
          ( ~ ( P @ X4 )
         => ? [Y4: A] :
              ( ( ord_less @ nat @ ( V @ Y4 ) @ ( V @ X4 ) )
              & ~ ( P @ Y4 ) ) )
     => ( P @ X ) ) ).

% infinite_descent_measure
thf(fact_94_measure__induct__rule,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X4: A] :
          ( ! [Y4: A] :
              ( ( ord_less @ nat @ ( F @ Y4 ) @ ( F @ X4 ) )
             => ( P @ Y4 ) )
         => ( P @ X4 ) )
     => ( P @ A2 ) ) ).

% measure_induct_rule
thf(fact_95_linorder__neqE__nat,axiom,
    ! [X: nat,Y: nat] :
      ( ( X != Y )
     => ( ~ ( ord_less @ nat @ X @ Y )
       => ( ord_less @ nat @ Y @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_96_infinite__descent,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P @ N2 )
         => ? [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
              & ~ ( P @ M2 ) ) )
     => ( P @ N ) ) ).

% infinite_descent
thf(fact_97_nat__less__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
             => ( P @ M2 ) )
         => ( P @ N2 ) )
     => ( P @ N ) ) ).

% nat_less_induct
thf(fact_98_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_99_measure__induct,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X4: A] :
          ( ! [Y4: A] :
              ( ( ord_less @ nat @ ( F @ Y4 ) @ ( F @ X4 ) )
             => ( P @ Y4 ) )
         => ( P @ X4 ) )
     => ( P @ A2 ) ) ).

% measure_induct
thf(fact_100_less__not__refl3,axiom,
    ! [S: nat,T2: nat] :
      ( ( ord_less @ nat @ S @ T2 )
     => ( S != T2 ) ) ).

% less_not_refl3
thf(fact_101_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_102_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_103_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_104_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type @ A ) )
     => ! [X: A,Y: A] :
          ( ( X != Y )
         => ( ~ ( ord_less @ A @ X @ Y )
           => ( ord_less @ A @ Y @ X ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_105_nat__add__left__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ K @ M )
        = ( plus_plus @ nat @ K @ N ) )
      = ( M = N ) ) ).

% nat_add_left_cancel
thf(fact_106_nat__add__right__cancel,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ K )
        = ( plus_plus @ nat @ N @ K ) )
      = ( M = N ) ) ).

% nat_add_right_cancel
thf(fact_107_less__add__eq__less,axiom,
    ! [K: nat,L: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ K @ L )
     => ( ( ( plus_plus @ nat @ M @ L )
          = ( plus_plus @ nat @ K @ N ) )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% less_add_eq_less
thf(fact_108_trans__less__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_less_add2
thf(fact_109_trans__less__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_less_add1
thf(fact_110_add__less__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_less_mono1
thf(fact_111_not__add__less2,axiom,
    ! [J: nat,I: nat] :
      ~ ( ord_less @ nat @ ( plus_plus @ nat @ J @ I ) @ I ) ).

% not_add_less2
thf(fact_112_not__add__less1,axiom,
    ! [I: nat,J: nat] :
      ~ ( ord_less @ nat @ ( plus_plus @ nat @ I @ J ) @ I ) ).

% not_add_less1
thf(fact_113_add__less__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ( ord_less @ nat @ K @ L )
       => ( ord_less @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ L ) ) ) ) ).

% add_less_mono
thf(fact_114_add__lessD1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ I @ J ) @ K )
     => ( ord_less @ nat @ I @ K ) ) ).

% add_lessD1
thf(fact_115_size__if__splay__max,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,L: tree @ A,U: A,R: tree @ A] :
          ( ( ( splay_splay_max @ A @ T2 )
            = ( node @ A @ L @ U @ R ) )
         => ( ( size_size @ ( tree @ A ) @ T2 )
            = ( plus_plus @ nat @ ( plus_plus @ nat @ ( size_size @ ( tree @ A ) @ L ) @ ( size_size @ ( tree @ A ) @ R ) ) @ ( one_one @ nat ) ) ) ) ) ).

% size_if_splay_max
thf(fact_116_path__len_Osimps_I2_J,axiom,
    ! [A: $tType,L: tree @ A,Uu: A,R: tree @ A] :
      ( ( path_len @ A @ ( node @ A @ L @ Uu @ R ) )
      = ( plus_plus @ nat @ ( plus_plus @ nat @ ( plus_plus @ nat @ ( path_len @ A @ L ) @ ( size_size @ ( tree @ A ) @ L ) ) @ ( path_len @ A @ R ) ) @ ( size_size @ ( tree @ A ) @ R ) ) ) ).

% path_len.simps(2)
thf(fact_117_fold__atLeastAtMost__nat_Oelims,axiom,
    ! [A: $tType,X: nat > A > A,Xa: nat,Xb: nat,Xc: A,Y: A] :
      ( ( ( set_fo292404081st_nat @ A @ X @ Xa @ Xb @ Xc )
        = Y )
     => ( ( ( ord_less @ nat @ Xb @ Xa )
         => ( Y = Xc ) )
        & ( ~ ( ord_less @ nat @ Xb @ Xa )
         => ( Y
            = ( set_fo292404081st_nat @ A @ X @ ( plus_plus @ nat @ Xa @ ( one_one @ nat ) ) @ Xb @ ( X @ Xa @ Xc ) ) ) ) ) ) ).

% fold_atLeastAtMost_nat.elims
thf(fact_118_fold__atLeastAtMost__nat_Osimps,axiom,
    ! [A: $tType] :
      ( ( set_fo292404081st_nat @ A )
      = ( ^ [F5: nat > A > A,A3: nat,B5: nat,Acc2: A] : ( if @ A @ ( ord_less @ nat @ B5 @ A3 ) @ Acc2 @ ( set_fo292404081st_nat @ A @ F5 @ ( plus_plus @ nat @ A3 @ ( one_one @ nat ) ) @ B5 @ ( F5 @ A3 @ Acc2 ) ) ) ) ) ).

% fold_atLeastAtMost_nat.simps
thf(fact_119_size__if__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,T2: tree @ A,L: tree @ A,U: A,R: tree @ A] :
          ( ( ( splay_splay @ A @ A2 @ T2 )
            = ( node @ A @ L @ U @ R ) )
         => ( ( size_size @ ( tree @ A ) @ T2 )
            = ( plus_plus @ nat @ ( plus_plus @ nat @ ( size_size @ ( tree @ A ) @ L ) @ ( size_size @ ( tree @ A ) @ R ) ) @ ( one_one @ nat ) ) ) ) ) ).

% size_if_splay
thf(fact_120_splay__Leaf__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,T2: tree @ A] :
          ( ( ( splay_splay @ A @ A2 @ T2 )
            = ( leaf @ A ) )
          = ( T2
            = ( leaf @ A ) ) ) ) ).

% splay_Leaf_iff
thf(fact_121_size__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,T2: tree @ A] :
          ( ( size_size @ ( tree @ A ) @ ( splay_splay @ A @ A2 @ T2 ) )
          = ( size_size @ ( tree @ A ) @ T2 ) ) ) ).

% size_splay
thf(fact_122_splay__max__Leaf__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A] :
          ( ( ( splay_splay_max @ A @ T2 )
            = ( leaf @ A ) )
          = ( T2
            = ( leaf @ A ) ) ) ) ).

% splay_max_Leaf_iff
thf(fact_123_splay__max__eq__splay__ex,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A] :
          ( ( linorder_bst @ A @ T2 )
         => ? [A4: A] :
              ( ( splay_splay_max @ A @ T2 )
              = ( splay_splay @ A @ A4 @ T2 ) ) ) ) ).

% splay_max_eq_splay_ex
thf(fact_124_splay_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,L: tree @ A,R: tree @ A] :
          ( ( splay_splay @ A @ A2 @ ( node @ A @ L @ A2 @ R ) )
          = ( node @ A @ L @ A2 @ R ) ) ) ).

% splay.simps(2)
thf(fact_125_splay_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( splay_splay @ A @ A2 @ ( leaf @ A ) )
          = ( leaf @ A ) ) ) ).

% splay.simps(1)
thf(fact_126_bst__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A] :
          ( ( linorder_bst @ A @ T2 )
         => ( linorder_bst @ A @ ( splay_splay @ A @ A2 @ T2 ) ) ) ) ).

% bst_splay
thf(fact_127_splay__max_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ( ( splay_splay_max @ A @ ( leaf @ A ) )
        = ( leaf @ A ) ) ) ).

% splay_max.simps(1)
thf(fact_128_bst__splay__max,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A] :
          ( ( linorder_bst @ A @ T2 )
         => ( linorder_bst @ A @ ( splay_splay_max @ A @ T2 ) ) ) ) ).

% bst_splay_max
thf(fact_129_size__splay__max,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A] :
          ( ( size_size @ ( tree @ A ) @ ( splay_splay_max @ A @ T2 ) )
          = ( size_size @ ( tree @ A ) @ T2 ) ) ) ).

% size_splay_max
thf(fact_130_splay_Osimps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,La: tree @ A,Ra: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( splay_splay @ A @ A2 @ ( node @ A @ ( node @ A @ La @ A2 @ Ra ) @ B3 @ Rb ) )
            = ( node @ A @ La @ A2 @ ( node @ A @ Ra @ B3 @ Rb ) ) ) ) ) ).

% splay.simps(3)
thf(fact_131_splay_Osimps_I9_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [B3: A,A2: A,Lb: tree @ A,La: tree @ A,Ra: tree @ A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( splay_splay @ A @ A2 @ ( node @ A @ Lb @ B3 @ ( node @ A @ La @ A2 @ Ra ) ) )
            = ( node @ A @ ( node @ A @ Lb @ B3 @ La ) @ A2 @ Ra ) ) ) ) ).

% splay.simps(9)
thf(fact_132_splay__not__Leaf,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A] :
          ( ( T2
           != ( leaf @ A ) )
         => ? [L3: tree @ A,X4: A,R3: tree @ A] :
              ( ( splay_splay @ A @ A2 @ T2 )
              = ( node @ A @ L3 @ X4 @ R3 ) ) ) ) ).

% splay_not_Leaf
thf(fact_133_splay_Osimps_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,R: tree @ A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( splay_splay @ A @ A2 @ ( node @ A @ ( leaf @ A ) @ B3 @ R ) )
            = ( node @ A @ ( leaf @ A ) @ B3 @ R ) ) ) ) ).

% splay.simps(4)
thf(fact_134_splay_Osimps_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: A,A2: A,B3: A,Ra: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ X @ A2 )
         => ( ( ord_less @ A @ X @ B3 )
           => ( ( splay_splay @ A @ X @ ( node @ A @ ( node @ A @ ( leaf @ A ) @ A2 @ Ra ) @ B3 @ Rb ) )
              = ( node @ A @ ( leaf @ A ) @ A2 @ ( node @ A @ Ra @ B3 @ Rb ) ) ) ) ) ) ).

% splay.simps(5)
thf(fact_135_splay_Osimps_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: A,B3: A,A2: A,La: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ X @ B3 )
         => ( ( ord_less @ A @ A2 @ X )
           => ( ( splay_splay @ A @ X @ ( node @ A @ ( node @ A @ La @ A2 @ ( leaf @ A ) ) @ B3 @ Rb ) )
              = ( node @ A @ La @ A2 @ ( node @ A @ ( leaf @ A ) @ B3 @ Rb ) ) ) ) ) ) ).

% splay.simps(7)
thf(fact_136_splay_Osimps_I10_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,X: A,L: tree @ A] :
          ( ( ord_less @ A @ A2 @ X )
         => ( ( splay_splay @ A @ X @ ( node @ A @ L @ A2 @ ( leaf @ A ) ) )
            = ( node @ A @ L @ A2 @ ( leaf @ A ) ) ) ) ) ).

% splay.simps(10)
thf(fact_137_splay_Osimps_I12_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,X: A,B3: A,La: tree @ A,Rb: tree @ A] :
          ( ( ord_less @ A @ A2 @ X )
         => ( ( ord_less @ A @ X @ B3 )
           => ( ( splay_splay @ A @ X @ ( node @ A @ La @ A2 @ ( node @ A @ ( leaf @ A ) @ B3 @ Rb ) ) )
              = ( node @ A @ ( node @ A @ La @ A2 @ ( leaf @ A ) ) @ B3 @ Rb ) ) ) ) ) ).

% splay.simps(12)
thf(fact_138_splay_Osimps_I13_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,X: A,B3: A,La: tree @ A,Lb: tree @ A] :
          ( ( ord_less @ A @ A2 @ X )
         => ( ( ord_less @ A @ B3 @ X )
           => ( ( splay_splay @ A @ X @ ( node @ A @ La @ A2 @ ( node @ A @ Lb @ B3 @ ( leaf @ A ) ) ) )
              = ( node @ A @ ( node @ A @ La @ A2 @ Lb ) @ B3 @ ( leaf @ A ) ) ) ) ) ) ).

% splay.simps(13)
thf(fact_139_splay__max__Leaf,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,L: tree @ A,A2: A,R: tree @ A] :
          ( ( ( splay_splay_max @ A @ T2 )
            = ( node @ A @ L @ A2 @ R ) )
         => ( R
            = ( leaf @ A ) ) ) ) ).

% splay_max_Leaf
thf(fact_140_splay__max_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [La: tree @ A,A2: A] :
          ( ( splay_splay_max @ A @ ( node @ A @ La @ A2 @ ( leaf @ A ) ) )
          = ( node @ A @ La @ A2 @ ( leaf @ A ) ) ) ) ).

% splay_max.simps(2)
thf(fact_141_path__len_Oelims,axiom,
    ! [A: $tType,X: tree @ A,Y: nat] :
      ( ( ( path_len @ A @ X )
        = Y )
     => ( ( ( X
            = ( leaf @ A ) )
         => ( Y
           != ( zero_zero @ nat ) ) )
       => ~ ! [L3: tree @ A,Uu2: A,R3: tree @ A] :
              ( ( X
                = ( node @ A @ L3 @ Uu2 @ R3 ) )
             => ( Y
               != ( plus_plus @ nat @ ( plus_plus @ nat @ ( plus_plus @ nat @ ( path_len @ A @ L3 ) @ ( size_size @ ( tree @ A ) @ L3 ) ) @ ( path_len @ A @ R3 ) ) @ ( size_size @ ( tree @ A ) @ R3 ) ) ) ) ) ) ).

% path_len.elims
thf(fact_142_ex__in__set__tree,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A] :
          ( ( T2
           != ( leaf @ A ) )
         => ( ( linorder_bst @ A @ T2 )
           => ? [X4: A] :
                ( ( member @ A @ X4 @ ( set_tree @ A @ T2 ) )
                & ( ( splay_splay @ A @ X4 @ T2 )
                  = ( splay_splay @ A @ A2 @ T2 ) )
                & ( ( splay_914434265_splay @ A @ X4 @ T2 )
                  = ( splay_914434265_splay @ A @ A2 @ T2 ) ) ) ) ) ) ).

% ex_in_set_tree
thf(fact_143_in__measure,axiom,
    ! [A: $tType,X: A,Y: A,F: A > nat] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( measure @ A @ F ) )
      = ( ord_less @ nat @ ( F @ X ) @ ( F @ Y ) ) ) ).

% in_measure
thf(fact_144_splay__bstR,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A,L: tree @ A,E3: A,R: tree @ A,X: A] :
          ( ( linorder_bst @ A @ T2 )
         => ( ( ( splay_splay @ A @ A2 @ T2 )
              = ( node @ A @ L @ E3 @ R ) )
           => ( ( member @ A @ X @ ( set_tree @ A @ R ) )
             => ( ord_less @ A @ A2 @ X ) ) ) ) ) ).

% splay_bstR
thf(fact_145_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_146_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B3 ) )
          = ( B3
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_147_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( A2
            = ( plus_plus @ A @ B3 @ A2 ) )
          = ( B3
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_148_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ( plus_plus @ A @ A2 @ B3 )
            = A2 )
          = ( B3
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_149_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ( plus_plus @ A @ B3 @ A2 )
            = A2 )
          = ( B3
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_150_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_151_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_152_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_153_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_154_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_155_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_156_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_157_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_double_add_iff_zero_less_single_add
thf(fact_158_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_less_zero_iff_single_add_less_zero
thf(fact_159_less__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ B3 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B3 ) ) ) ).

% less_add_same_cancel2
thf(fact_160_less__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ A2 @ B3 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B3 ) ) ) ).

% less_add_same_cancel1
thf(fact_161_add__less__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ B3 ) @ B3 )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel2
thf(fact_162_add__less__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ B3 @ A2 ) @ B3 )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel1
thf(fact_163_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( plus_plus @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% add_gr_0
thf(fact_164_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( one_one @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_one
thf(fact_165_dbl__inc__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type @ A ) )
     => ( ( neg_numeral_dbl_inc @ A @ ( zero_zero @ A ) )
        = ( one_one @ A ) ) ) ).

% dbl_inc_simps(2)
thf(fact_166_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A @ ( type @ A ) )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_167_tree_Oset__intros_I3_J,axiom,
    ! [A: $tType,Xa: A,A32: tree @ A,A1: tree @ A,A22: A] :
      ( ( member @ A @ Xa @ ( set_tree @ A @ A32 ) )
     => ( member @ A @ Xa @ ( set_tree @ A @ ( node @ A @ A1 @ A22 @ A32 ) ) ) ) ).

% tree.set_intros(3)
thf(fact_168_tree_Oset__intros_I2_J,axiom,
    ! [A: $tType,A22: A,A1: tree @ A,A32: tree @ A] : ( member @ A @ A22 @ ( set_tree @ A @ ( node @ A @ A1 @ A22 @ A32 ) ) ) ).

% tree.set_intros(2)
thf(fact_169_tree_Oset__intros_I1_J,axiom,
    ! [A: $tType,X: A,A1: tree @ A,A22: A,A32: tree @ A] :
      ( ( member @ A @ X @ ( set_tree @ A @ A1 ) )
     => ( member @ A @ X @ ( set_tree @ A @ ( node @ A @ A1 @ A22 @ A32 ) ) ) ) ).

% tree.set_intros(1)
thf(fact_170_tree_Oset__cases,axiom,
    ! [A: $tType,E3: A,A2: tree @ A] :
      ( ( member @ A @ E3 @ ( set_tree @ A @ A2 ) )
     => ( ! [Z1: tree @ A] :
            ( ? [Z2: A,Z3: tree @ A] :
                ( A2
                = ( node @ A @ Z1 @ Z2 @ Z3 ) )
           => ~ ( member @ A @ E3 @ ( set_tree @ A @ Z1 ) ) )
       => ( ! [Z1: tree @ A,Z3: tree @ A] :
              ( A2
             != ( node @ A @ Z1 @ E3 @ Z3 ) )
         => ~ ! [Z1: tree @ A,Z2: A,Z3: tree @ A] :
                ( ( A2
                  = ( node @ A @ Z1 @ Z2 @ Z3 ) )
               => ~ ( member @ A @ E3 @ ( set_tree @ A @ Z3 ) ) ) ) ) ) ).

% tree.set_cases
thf(fact_171_set__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,T2: tree @ A] :
          ( ( set_tree @ A @ ( splay_splay @ A @ A2 @ T2 ) )
          = ( set_tree @ A @ T2 ) ) ) ).

% set_splay
thf(fact_172_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_173_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_174_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_175_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_176_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_177_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [X: A,Y: A] :
          ( ( ( plus_plus @ A @ X @ Y )
            = ( zero_zero @ A ) )
          = ( ( X
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_178_add_Ogroup__left__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.group_left_neutral
thf(fact_179_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.comm_neutral
thf(fact_180_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_add_class.add_0
thf(fact_181_zero__neq__one,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ( ( zero_zero @ A )
       != ( one_one @ A ) ) ) ).

% zero_neq_one
thf(fact_182_infinite__descent0__measure,axiom,
    ! [A: $tType,V: A > nat,P: A > $o,X: A] :
      ( ! [X4: A] :
          ( ( ( V @ X4 )
            = ( zero_zero @ nat ) )
         => ( P @ X4 ) )
     => ( ! [X4: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V @ X4 ) )
           => ( ~ ( P @ X4 )
             => ? [Y4: A] :
                  ( ( ord_less @ nat @ ( V @ Y4 ) @ ( V @ X4 ) )
                  & ~ ( P @ Y4 ) ) ) )
       => ( P @ X ) ) ) ).

% infinite_descent0_measure
thf(fact_183_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_184_infinite__descent0,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
           => ( ~ ( P @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less @ nat @ M2 @ N2 )
                  & ~ ( P @ M2 ) ) ) )
       => ( P @ N ) ) ) ).

% infinite_descent0
thf(fact_185_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_186_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_187_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_188_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_189_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_190_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_191_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = M )
     => ( N
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_192_set__splay__max,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A] :
          ( ( set_tree @ A @ ( splay_splay_max @ A @ T2 ) )
          = ( set_tree @ A @ T2 ) ) ) ).

% set_splay_max
thf(fact_193_pos__add__strict,axiom,
    ! [A: $tType] :
      ( ( strict797366125id_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ B3 @ C3 )
           => ( ord_less @ A @ B3 @ ( plus_plus @ A @ A2 @ C3 ) ) ) ) ) ).

% pos_add_strict
thf(fact_194_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ B3 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ B3 ) ) ) ) ) ).

% add_pos_pos
thf(fact_195_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ B3 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( plus_plus @ A @ A2 @ B3 ) @ ( zero_zero @ A ) ) ) ) ) ).

% add_neg_neg
thf(fact_196_zero__less__one,axiom,
    ! [A: $tType] :
      ( ( zero_less_one @ A @ ( type @ A ) )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% zero_less_one
thf(fact_197_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% not_one_less_zero
thf(fact_198_less__numeral__extra_I2_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(2)
thf(fact_199_less__numeral__extra_I1_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(1)
thf(fact_200_less__imp__add__positive,axiom,
    ! [I: nat,J: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ? [K2: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K2 )
          & ( ( plus_plus @ nat @ I @ K2 )
            = J ) ) ) ).

% less_imp_add_positive
thf(fact_201_tree_Osize_I3_J,axiom,
    ! [A: $tType] :
      ( ( size_size @ ( tree @ A ) @ ( leaf @ A ) )
      = ( zero_zero @ nat ) ) ).

% tree.size(3)
thf(fact_202_size__0__iff__Leaf,axiom,
    ! [A: $tType,T2: tree @ A] :
      ( ( ( size_size @ ( tree @ A ) @ T2 )
        = ( zero_zero @ nat ) )
      = ( T2
        = ( leaf @ A ) ) ) ).

% size_0_iff_Leaf
thf(fact_203_size1__ge0,axiom,
    ! [A: $tType,T2: tree @ A] : ( ord_less @ nat @ ( zero_zero @ nat ) @ ( size1 @ A @ T2 ) ) ).

% size1_ge0
thf(fact_204_path__len_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( path_len @ A @ ( leaf @ A ) )
      = ( zero_zero @ nat ) ) ).

% path_len.simps(1)
thf(fact_205_splay__to__root,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A,T5: tree @ A] :
          ( ( linorder_bst @ A @ T2 )
         => ( ( ( splay_splay @ A @ A2 @ T2 )
              = T5 )
           => ( ( member @ A @ A2 @ ( set_tree @ A @ T2 ) )
              = ( ? [L2: tree @ A,R2: tree @ A] :
                    ( T5
                    = ( node @ A @ L2 @ A2 @ R2 ) ) ) ) ) ) ) ).

% splay_to_root
thf(fact_206_zero__less__two,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A @ ( type @ A ) )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ) ).

% zero_less_two
thf(fact_207_splay__bstL,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A,L: tree @ A,E3: A,R: tree @ A,X: A] :
          ( ( linorder_bst @ A @ T2 )
         => ( ( ( splay_splay @ A @ A2 @ T2 )
              = ( node @ A @ L @ E3 @ R ) )
           => ( ( member @ A @ X @ ( set_tree @ A @ L ) )
             => ( ord_less @ A @ X @ A2 ) ) ) ) ) ).

% splay_bstL
thf(fact_208_set__treeE,axiom,
    ! [A: $tType,A2: A,T2: tree @ A] :
      ( ( member @ A @ A2 @ ( set_tree @ A @ T2 ) )
     => ? [L3: tree @ A,R3: tree @ A] : ( member @ ( tree @ A ) @ ( node @ A @ L3 @ A2 @ R3 ) @ ( subtrees @ A @ T2 ) ) ) ).

% set_treeE
thf(fact_209_in__set__tree__if,axiom,
    ! [A: $tType,L: tree @ A,A2: A,R: tree @ A,T2: tree @ A] :
      ( ( member @ ( tree @ A ) @ ( node @ A @ L @ A2 @ R ) @ ( subtrees @ A @ T2 ) )
     => ( member @ A @ A2 @ ( set_tree @ A @ T2 ) ) ) ).

% in_set_tree_if
thf(fact_210_Node__notin__subtrees__if,axiom,
    ! [A: $tType,A2: A,T2: tree @ A,L: tree @ A,R: tree @ A] :
      ( ~ ( member @ A @ A2 @ ( set_tree @ A @ T2 ) )
     => ~ ( member @ ( tree @ A ) @ ( node @ A @ L @ A2 @ R ) @ ( subtrees @ A @ T2 ) ) ) ).

% Node_notin_subtrees_if
thf(fact_211_is__root__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A] :
          ( ( linorder_bst @ A @ T2 )
         => ( ( splay_is_root @ A @ A2 @ ( splay_splay @ A @ A2 @ T2 ) )
            = ( member @ A @ A2 @ ( set_tree @ A @ T2 ) ) ) ) ) ).

% is_root_splay
thf(fact_212_ind__euclid,axiom,
    ! [P: nat > nat > $o,A2: nat,B3: nat] :
      ( ! [A4: nat,B2: nat] :
          ( ( P @ A4 @ B2 )
          = ( P @ B2 @ A4 ) )
     => ( ! [A4: nat] : ( P @ A4 @ ( zero_zero @ nat ) )
       => ( ! [A4: nat,B2: nat] :
              ( ( P @ A4 @ B2 )
             => ( P @ A4 @ ( plus_plus @ nat @ A4 @ B2 ) ) )
         => ( P @ A2 @ B3 ) ) ) ) ).

% ind_euclid
thf(fact_213_add__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type @ A ) )
     => ! [B3: A,A2: A] :
          ( ( B3
            = ( plus_plus @ A @ B3 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% add_0_iff
thf(fact_214_semiring__normalization__rules_I5_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(5)
thf(fact_215_semiring__normalization__rules_I20_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A,D: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B3 ) @ ( plus_plus @ A @ C3 @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C3 ) @ ( plus_plus @ A @ B3 @ D ) ) ) ) ).

% semiring_normalization_rules(20)
thf(fact_216_semiring__normalization__rules_I21_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B3 ) @ C3 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B3 @ C3 ) ) ) ) ).

% semiring_normalization_rules(21)
thf(fact_217_semiring__normalization__rules_I22_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,C3: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C3 @ D ) )
          = ( plus_plus @ A @ C3 @ ( plus_plus @ A @ A2 @ D ) ) ) ) ).

% semiring_normalization_rules(22)
thf(fact_218_semiring__normalization__rules_I23_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B3: A,C3: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B3 ) @ C3 )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C3 ) @ B3 ) ) ) ).

% semiring_normalization_rules(23)
thf(fact_219_semiring__normalization__rules_I24_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A3: A,C4: A] : ( plus_plus @ A @ C4 @ A3 ) ) ) ) ).

% semiring_normalization_rules(24)
thf(fact_220_semiring__normalization__rules_I25_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,C3: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C3 @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C3 ) @ D ) ) ) ).

% semiring_normalization_rules(25)
thf(fact_221_semiring__normalization__rules_I6_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(6)
thf(fact_222_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B,A5: A,B4: B,R: set @ ( product_prod @ A @ A ),S: set @ ( product_prod @ B @ B )] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B3 ) @ ( product_Pair @ A @ B @ A5 @ B4 ) ) @ ( lex_prod @ A @ B @ R @ S ) )
      = ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A5 ) @ R )
        | ( ( A2 = A5 )
          & ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ B3 @ B4 ) @ S ) ) ) ) ).

% in_lex_prod
thf(fact_223_bst_Oelims_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: tree @ A,Y: $o] :
          ( ( ( linorder_bst @ A @ X )
            = Y )
         => ( ( ( X
                = ( leaf @ A ) )
             => ~ Y )
           => ~ ! [L3: tree @ A,A4: A,R3: tree @ A] :
                  ( ( X
                    = ( node @ A @ L3 @ A4 @ R3 ) )
                 => ( Y
                    = ( ~ ( ( linorder_bst @ A @ L3 )
                          & ( linorder_bst @ A @ R3 )
                          & ! [X5: A] :
                              ( ( member @ A @ X5 @ ( set_tree @ A @ L3 ) )
                             => ( ord_less @ A @ X5 @ A4 ) )
                          & ! [X5: A] :
                              ( ( member @ A @ X5 @ ( set_tree @ A @ R3 ) )
                             => ( ord_less @ A @ A4 @ X5 ) ) ) ) ) ) ) ) ) ).

% bst.elims(1)
thf(fact_224_bst_Oelims_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: tree @ A] :
          ( ~ ( linorder_bst @ A @ X )
         => ~ ! [L3: tree @ A,A4: A,R3: tree @ A] :
                ( ( X
                  = ( node @ A @ L3 @ A4 @ R3 ) )
               => ( ( linorder_bst @ A @ L3 )
                  & ( linorder_bst @ A @ R3 )
                  & ! [X4: A] :
                      ( ( member @ A @ X4 @ ( set_tree @ A @ L3 ) )
                     => ( ord_less @ A @ X4 @ A4 ) )
                  & ! [X4: A] :
                      ( ( member @ A @ X4 @ ( set_tree @ A @ R3 ) )
                     => ( ord_less @ A @ A4 @ X4 ) ) ) ) ) ) ).

% bst.elims(3)
thf(fact_225_bst_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [L: tree @ A,A2: A,R: tree @ A] :
          ( ( linorder_bst @ A @ ( node @ A @ L @ A2 @ R ) )
          = ( ( linorder_bst @ A @ L )
            & ( linorder_bst @ A @ R )
            & ! [X5: A] :
                ( ( member @ A @ X5 @ ( set_tree @ A @ L ) )
               => ( ord_less @ A @ X5 @ A2 ) )
            & ! [X5: A] :
                ( ( member @ A @ X5 @ ( set_tree @ A @ R ) )
               => ( ord_less @ A @ A2 @ X5 ) ) ) ) ) ).

% bst.simps(2)
thf(fact_226_bst_Oelims_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [X: tree @ A] :
          ( ( linorder_bst @ A @ X )
         => ( ( X
             != ( leaf @ A ) )
           => ~ ! [L3: tree @ A,A4: A,R3: tree @ A] :
                  ( ( X
                    = ( node @ A @ L3 @ A4 @ R3 ) )
                 => ~ ( ( linorder_bst @ A @ L3 )
                      & ( linorder_bst @ A @ R3 )
                      & ! [X6: A] :
                          ( ( member @ A @ X6 @ ( set_tree @ A @ L3 ) )
                         => ( ord_less @ A @ X6 @ A4 ) )
                      & ! [X6: A] :
                          ( ( member @ A @ X6 @ ( set_tree @ A @ R3 ) )
                         => ( ord_less @ A @ A4 @ X6 ) ) ) ) ) ) ) ).

% bst.elims(2)
thf(fact_227_mlex__less,axiom,
    ! [A: $tType,F: A > nat,X: A,Y: A,R4: set @ ( product_prod @ A @ A )] :
      ( ( ord_less @ nat @ ( F @ X ) @ ( F @ Y ) )
     => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( mlex_prod @ A @ F @ R4 ) ) ) ).

% mlex_less
thf(fact_228_splay__max__eq__splay,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [T2: tree @ A,A2: A] :
          ( ( linorder_bst @ A @ T2 )
         => ( ! [X4: A] :
                ( ( member @ A @ X4 @ ( set_tree @ A @ T2 ) )
               => ( ord_less_eq @ A @ X4 @ A2 ) )
           => ( ( splay_splay_max @ A @ T2 )
              = ( splay_splay @ A @ A2 @ T2 ) ) ) ) ) ).

% splay_max_eq_splay
thf(fact_229_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_230_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_231_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_232_add__le__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [A2: A,C3: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ C3 ) @ ( plus_plus @ A @ B3 @ C3 ) )
          = ( ord_less_eq @ A @ A2 @ B3 ) ) ) ).

% add_le_cancel_right
thf(fact_233_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [C3: A,A2: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ C3 @ A2 ) @ ( plus_plus @ A @ C3 @ B3 ) )
          = ( ord_less_eq @ A @ A2 @ B3 ) ) ) ).

% add_le_cancel_left
thf(fact_234_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_le_double_add_iff_zero_le_single_add
thf(fact_235_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_le_zero_iff_single_add_le_zero
thf(fact_236_le__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ B3 @ A2 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B3 ) ) ) ).

% le_add_same_cancel2
thf(fact_237_le__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ ( plus_plus @ A @ A2 @ B3 ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ B3 ) ) ) ).

% le_add_same_cancel1
thf(fact_238_add__le__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ A2 @ B3 ) @ B3 )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel2
thf(fact_239_add__le__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less_eq @ A @ ( plus_plus @ A @ B3 @ A2 ) @ B3 )
          = ( ord_less_eq @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_le_same_cancel1
thf(fact_240_mlex__leq,axiom,
    ! [A: $tType,F: A > nat,X: A,Y: A,R4: set @ ( product_prod @ A @ A )] :
      ( ( ord_less_eq @ nat @ ( F @ X ) @ ( F @ Y ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R4 )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( mlex_prod @ A @ F @ R4 ) ) ) ) ).

% mlex_leq
thf(fact_241_add__leE,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ~ ( ( ord_less_eq @ nat @ M @ N )
         => ~ ( ord_less_eq @ nat @ K @ N ) ) ) ).

% add_leE
thf(fact_242_le__add1,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ N @ M ) ) ).

% le_add1
thf(fact_243_le__add2,axiom,
    ! [N: nat,M: nat] : ( ord_less_eq @ nat @ N @ ( plus_plus @ nat @ M @ N ) ) ).

% le_add2
thf(fact_244_add__leD1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% add_leD1
thf(fact_245_add__leD2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ M @ K ) @ N )
     => ( ord_less_eq @ nat @ K @ N ) ) ).

% add_leD2
thf(fact_246_le__Suc__ex,axiom,
    ! [K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ K @ L )
     => ? [N2: nat] :
          ( L
          = ( plus_plus @ nat @ K @ N2 ) ) ) ).

% le_Suc_ex
thf(fact_247_add__le__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ K @ L )
       => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ L ) ) ) ) ).

% add_le_mono
thf(fact_248_add__le__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_le_mono1
thf(fact_249_trans__le__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_le_add1
thf(fact_250_trans__le__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ord_less_eq @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_le_add2
thf(fact_251_nat__le__iff__add,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M3: nat,N3: nat] :
        ? [K3: nat] :
          ( N3
          = ( plus_plus @ nat @ M3 @ K3 ) ) ) ) ).

% nat_le_iff_add
thf(fact_252_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less @ nat @ I2 @ J2 )
         => ( ord_less @ nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I @ J )
       => ( ord_less_eq @ nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono

%----Type constructors (50)
thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__monoid__add__imp__le,axiom,
    ordere516151231imp_le @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ostrict__ordered__ab__semigroup__add,axiom,
    strict2144017051up_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ostrict__ordered__comm__monoid__add,axiom,
    strict797366125id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ozero__less__one,axiom,
    zero_less_one @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oone,axiom,
    one @ nat @ ( type @ nat ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_1,axiom,
    linorder @ $o @ ( type @ $o ) ).

thf(tcon_Real_Oreal___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct_2,axiom,
    semiri456707255roduct @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__semigroup__monoid__add__imp__le_3,axiom,
    ordere516151231imp_le @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ostrict__ordered__ab__semigroup__add_4,axiom,
    strict2144017051up_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oordered__cancel__ab__semigroup__add_5,axiom,
    ordere223160158up_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__semigroup__add__imp__le_6,axiom,
    ordere236663937imp_le @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ostrict__ordered__comm__monoid__add_7,axiom,
    strict797366125id_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Olinordered__nonzero__semiring_8,axiom,
    linord1659791738miring @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__semigroup__add_9,axiom,
    ordere779506340up_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oordered__comm__monoid__add_10,axiom,
    ordere216010020id_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ocancel__comm__monoid__add_11,axiom,
    cancel1352612707id_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ocancel__semigroup__add_12,axiom,
    cancel_semigroup_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Olinordered__semidom_13,axiom,
    linordered_semidom @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oab__semigroup__add_14,axiom,
    ab_semigroup_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ocomm__monoid__add_15,axiom,
    comm_monoid_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__1_16,axiom,
    comm_semiring_1 @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Osemigroup__add_17,axiom,
    semigroup_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Ozero__less__one_18,axiom,
    zero_less_one @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Ozero__neq__one_19,axiom,
    zero_neq_one @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Orderings_Olinorder_20,axiom,
    linorder @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Omonoid__add_21,axiom,
    monoid_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ogroup__add,axiom,
    group_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Num_Oneg__numeral,axiom,
    neg_numeral @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Ozero_22,axiom,
    zero @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oone_23,axiom,
    one @ real @ ( type @ real ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    $false ).

%------------------------------------------------------------------------------
